# Create a Kubernetes cluster and deploy a wordpress

In this tutorial we will create a kubernetes cluster on try.whitesky.cloud with terraform and ansible. After that we'll use the try-whitesky-cloud-csi-driver together with helm to deploy applications in our kubernetes cluster. As an example, we'll deploy a wordpress website with TLS enabled!

## Deploy Kubernetes cluster
### Preparing the required files

Adjust the terraform.tfvars to deploy a kubernetes ready set of linux servers.
1. Copy terraform.tfvars.example to terraform.tfvars

2. Adjust the customer_id, client_jwt, cloudspace_name, location and external_network_id inside `terraform.tvars`
  - **external_network_id:** You can find the external networks for your chosen location by using the API: 
                             `/customers/{customer_id}/locations/{location}/external-networks`
                             Get the correct external_network_id which represents the external network connected to the internet.

3. Initialize your terraform directory
    `terraform init`

4. Apply your terraform configuration
    `terraform apply`

5. Wait for all resources to be deployed. The public IP of your cloudspace will be outputted at the end.

### Steps to deploy the kubernetes cluster

1. SSH into your kube-mgt vm (`ssh -A -p 2222 root@PUBLIC_IP`)
    (Windows only) Copy your private key to the kube-mgt so the vm has access to the other vm’s
                   `scp -P 2222 LOCATION_OF_ID_RSA root@PUBLIC_IP:/root/.ssh/id_rsa`
                   ssh to kube-mgt and do `chmod 400 ~/.ssh/id_rsa` to set the correct permissions for you private key

2. Go into the ansible directory
    `cd ansible`

3. clone kubespray repository and checkout tag v2.16.0.
   (You can checkout a more recent tag if you want to (or master). We're using this tag because this one is tested multiple times and works.)
    `git clone https://github.com/kubernetes-sigs/kubespray.git`
    `cd kubespray/`
    `git checkout tags/v2.16.0 -b myBranch`

4. Install requirements using pip3
    `pip3 install -r requirements.txt`

5. Copy example group_vars and our inventory file
    `cp -rfp inventory/sample inventory/mycluster`
    `cp ../inventory.ini inventory/mycluster` #copy generated inventory file by terraform

5. Configure variables
    Configure variables in inventory/mycluster/group_vars/k8s_cluster/k8s-cluster.yml
    `cluster_name: "<NAME_OF_CLUSTER>"`
    `supplementary_addresses_in_ssl_keys:  [<PUBLIC_IP>]`

6. Execute playbook
    `ansible-playbook -i inventory/mycluster/inventory.ini cluster.yml -v -b`

7. Copy your kubeconfig from the master node and adjust the IP 
    `mkdir /root/.kube`
    `scp MASTER_NODE_IP:/etc/kubernetes/admin.conf /root/.kube/config`
    - Change `server: https://127.0.0.1:6443` to `https://MASTER_NODE_IP:6443` 
    (Optional) Copy your kubeconfig to your localhost and change the IP to the public IP of the cloudspace

8. Check you kubernetes cluster
    Install kubectl binary: 
    `curl -LO "https://dl.k8s.io/release/$(curl -L -s https://dl.k8s.io/release/stable.txt)/bin/linux/amd64/kubectl"`
    `sudo install -o root -g root -m 0755 kubectl /usr/local/bin/kubectl`

    `kubectl get nodes` # All nodes should be ready
    `kubectl get pods -n kube-system` # All pods should be running

### Steps to deploy the CSI-Driver

1. Check if ansible files are present on the jumphost (should have been copied in step 2 of deploying the kubernetes cluster)
    `cd /root/ansible`
    `ls -alh`

2. Adjust the needed variables in `install-csi-driver.yml`:
    `vi install-csi-driver.yml`
    a. customer_id
    b. client_jwt

3. Run the ansible-playbook
    `ansible-playbook install-csi-driver.yml`

3. Check if all pods are up in the csi-driver namespace (You might need to wait a bit until they are.)
    `kubectl get pods -n csi-driver` 


### Install helm to deploy applications

    ```
    curl -fsSL -o get_helm.sh https://raw.githubusercontent.com/helm/helm/master/scripts/get-helm-3
    chmod 700 get_helm.sh
    ./get_helm.sh
    ```

### Install Ingress, Cert-Manager and a Wordpress website using helm

1. Install ingress
    ```helm repo add ingress-nginx https://kubernetes.github.io/ingress-nginx
    helm repo update
    helm install ingress ingress-nginx/ingress-nginx -f helm/ingress-values.yaml```

2. Install Cert-Manager to manage certificates.
    ```helm repo add jetstack https://charts.jetstack.io
    helm repo update
    helm install cert-manager jetstack/cert-manager --namespace cert-manager --create-namespace --version v1.3.1 --set installCRDs=true```

3. Deploy letsencrypt-issuer (Let's Encrypt is a free to use CA)
    Adjust the emailaddress in helm/letsencrypt-issuer.yaml
    `kubectl apply -f helm/letsencrypt-issuer.yaml`

4. Deploy your wordpress
    Adjust the variables in helm/wordpress-values.yaml :
    ```
    hostname: example.com   # This needs to be a valid domain, pointing towards the public IP of your cloudspace.
    ...
    wordpressUsername: user
    wordpressPassword: user1234
    wordpressEmail: user@example.com
    wordpressFirstName: Bob
    wordpressLastName: Ross
    wordpressBlogName: testsite
    ```
    Now you can deploy your wordpress cluster
    ```helm repo add bitnami https://charts.bitnami.com/bitnami
    helm repo update
    helm install wordpress bitnami/wordpress -f helm/wordpress-values.yaml```