variable "client_jwt" {
  description = "try-whitesky-cloud JWT"
}
variable "customer_id" {
  description = "customer id"
}

variable "location" {
  description = "location"
}

variable "vm_description" {
  description = "Description of the VM"
  default = "Kubernetes Cluster"
}

variable "image_id" {
  description = "Image_id"
  default     = "1"
}

variable "disksize" {
  description = "disksize"
  default     = "20"
}

variable "memory" {
  description = "Size of the memory for each vm"
  default     = 2048
}

variable "vcpus" {
  description = "Number of vcpus for each vm"
  default     = 2
}

variable "ssh_key_pub" {
  description = "SSH key that will be available on all nodes"
  default     = ""
}

variable "ssh_key_private_location" {
  description = "Location of your private key."
  default = ""
}

variable "known_hosts_location" {
  description = "Location of the known hosts file"
  default = "~/.ssh/known_hosts"
}

variable "master_count" {
  description = "Number of masters"
  default     = "1"
}

variable "worker_count" {
  description = "Number of workers"
  default     = "3"
}

variable "cloudspace_name" {
  description = "Name of cloudspace"
  default     = "Cloudspace"
}

variable "external_network_id" {
  description = "ID of the external network. You can find this by using the API"
}